# 등비수열

연속된 두 항의 비율이 항상 같을 때 그 수열을 `등비수열`이라고 한다. 간단히 말해, 이전 항에 상수를 곱하여 다음 항을 계산하여 등비수열을 만들 수 있다.

예를 들어, `2, 4, 8, 16`은 연속된 두 항의 비율(공비)가 모두 같으므로 등비수열이다 (4 / 2 = 8 / 4 = 16 / 8 = 2).

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635376-2fad6f80-d101-11eb-9d06-74c5c854cc9d.png">
</p>

**등비수열에 관한 사실들:**

1. **초항:** 등비수열에서, 첫 항은 초항이라고 불린다.
2. **공비:** 다음 항을 이전 항으로 나누어 나타낸 연속된 두 항의 비율
3. 등비수열은 공비에 따라 여러 경향을 보인다. 만약 공비가:
   - 양수이면, 모든 항은 첫 항과 같은 부호를 가진다.
   - 음수이면, 부호가 번갈아 가며 나타난다.
   - 1보다 크면, (초항의 부호에 따라) 양의 무한대 또는 음의 무한대를 향해 지수적으로 증가한다.
   - 1이면, 모든 항의 값이 같은 상수수열이다.
   - −1과 1사이에 있지만 0이 아니면, 0을 향해 지수적으로 감소한다.
   - −1이면, 모든 항의 절댓값은 같지만, 부호가 번갈아 가며 나타난다.
   - -1보다 작으면, 부호가 번갈아 가며 나타나고, 절대값은 양의 무한대를 향해 지수적으로 증가한다.

**등비수열의 n번째 항 공식:**

<img src="https://render.githubusercontent.com/render/math?math=a">가 초항, <img src="https://render.githubusercontent.com/render/math?math=r">이 공비일 때, <img src="https://render.githubusercontent.com/render/math?math=n">번째 항은:

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635586-6fc12200-d102-11eb-9a87-333c9a578cc8.png">
</p>

**등비급수(등비수열의 첫 n항의 합) 공식:**

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635613-9717ef00-d102-11eb-89db-5182e966b1db.png">
</p>

**등비수열에 관련된 문제를 풀기 위한 일반적인 공식:**

<img src="https://render.githubusercontent.com/render/math?math=a">가 초항, <img src="https://render.githubusercontent.com/render/math?math=r">이 공비일 때:

- 등비급수 (r < 1) = <img src="https://render.githubusercontent.com/render/math?math=\frac{a(1-r^n)}{1-r}">
- 등비급수 (r > 1) = <img src="https://render.githubusercontent.com/render/math?math=\frac{a(r^n-1)}{r-1}">
- 무한등비급수 (r < 1) = <img src="https://render.githubusercontent.com/render/math?math=\frac{a}{1-r}">

## 영상 URL

- [Don't Memorise](https://youtu.be/gua96ju_FBk)
- [Code Bashers (C++)](https://youtu.be/92ZldzuGUHs)

## 출처

- [GeeksforGeeks](https://www.geeksforgeeks.org/geometric-progression/)
